/* $Header: /local/src/CVS/nickle/builtin-environ.c,v 1.5 2004/04/16 21:41:52 keithp Exp $ */

/*
 * Copyright © 1988-2004 Keith Packard and Bart Massey.
 * All Rights Reserved.  See the file COPYING in this directory
 * for licensing information.
 */

/*
 *	environ.c
 *
 *	provide builtin functions for the Environ namespace
 */

#include	<ctype.h>
#include	<strings.h>
#include	<time.h>
#include	"builtin.h"

NamespacePtr EnvironNamespace;

void
import_Environ_namespace()
{
    ENTER ();
    static const struct fbuiltin_1 funcs_1[] = {
        { do_Environ_check, "check", "b", "s" },
        { do_Environ_get, "get", "s", "s" },
        { do_Environ_unset, "unset", "b", "s" },
        { 0 }
    };

    static const struct fbuiltin_2 funcs_2[] = {
        { do_Environ_set, "set", "b", "ss" },
        { 0 }
    };

    EnvironNamespace = BuiltinNamespace (/*parent*/ 0, "Environ")->namespace.namespace;

    BuiltinFuncs1 (&EnvironNamespace, funcs_1);
    BuiltinFuncs2 (&EnvironNamespace, funcs_2);
    EXIT ();
}

Value
do_Environ_get (Value av)
{
    ENTER ();
    char    *name = StrzPart (av, "invalid environment variable name");
    char    *c;

    if (!name)
	RETURN (Void);
    c = getenv (name);
    if (!c) {
	RaiseStandardException (exception_invalid_argument,
				"name not available",
				2, NewInt(0), av);
	RETURN (Void);
    }
    RETURN (NewStrString (c));
}

Value
do_Environ_check (Value av)
{
    ENTER ();
    char    *name = StrzPart (av, "invalid environment variable name");

    if (!name)
	RETURN (Void);
    if (getenv (name))
	RETURN (TrueVal);
    RETURN (FalseVal);
}

Value
do_Environ_unset (Value av)
{
    ENTER ();
    char    *name = StrzPart (av, "invalid environment variable name");
    
    if (!name)
	RETURN (Void);
    
#if HAVE_UNSETENV
    if (getenv (name))
    {
	unsetenv (name);
	RETURN (TrueVal);
    }
#endif
    RETURN (FalseVal);
}

Value
do_Environ_set (Value name, Value value)
{
    ENTER ();
    char    *n = StrzPart (name, "invalid environment variable name");
    char    *v = StrzPart (value, "invalid environment variable value");

    if (!n || !v)
	RETURN (Void);
#if HAVE_SETENV
    if (setenv (n, v, 1) >= 0)
	RETURN (TrueVal);
#else
#if HAVE_PUTENV
    {
	Value	binding = Plus (name,
				Plus (NewStrString ("="),
				      value));
	char	*b = StrzPart (binding, "invalid environment variable binding");

	if (!b)
	    RETURN (Void);
	if (putenv (b) >= 0)
	    RETURN (TrueVal);
    }
#endif
#endif
    RETURN (FalseVal);
}
