/* $Header: /local/src/CVS/nickle/profile.c,v 1.10 2004/02/27 03:50:16 keithp Exp $ */

/*
 * Copyright © 1988-2004 Keith Packard and Bart Massey.
 * All Rights Reserved.  See the file COPYING in this directory
 * for licensing information.
 */

#include	"nickle.h"
#include	<sys/time.h>
#include	<assert.h>

volatile static unsigned long	currentTick;
volatile Bool			signalProfile;
static unsigned long		previousTick;
Bool				profiling;

static RETSIGTYPE
sigprofile (int sig)
{
    resetSignal (SIGVTALRM, sigprofile);
    currentTick++;
    SetSignalProfile ();
}

void
ProfileInterrupt (Value thread)
{
    unsigned long   ticks = currentTick - previousTick;
    InstPtr	    pc;
    ExprPtr	    stat;
    FramePtr	    frame;
    
    previousTick = 0;
    if (!thread)
	return;
    pc = thread->thread.continuation.pc;
    if (pc)
    {
	stat = ObjStatement (thread->thread.continuation.obj,pc);
	if (stat)
	{
	    stat->base.ticks += ticks;
	}
    }
    for (frame = thread->thread.continuation.frame; frame; frame = frame->previous)
    {
	pc = frame->savePc;
        stat = ObjStatement (frame->saveObj, frame->savePc);
        if (stat)
	    stat->base.sub_ticks += ticks;
    }
}

Value
do_profile (Value on)
{
    struct itimerval    v;
    Bool    previous = profiling;
	
    if (True (on))
    {
	currentTick = previousTick = 0;
	catchSignal (SIGVTALRM, sigprofile);
	v.it_interval.tv_sec = 0;
	v.it_interval.tv_usec = 10000;
	v.it_value = v.it_interval;
	setitimer (ITIMER_VIRTUAL, &v, 0);
	profiling = True;
    }
    else
    {
	v.it_interval.tv_sec = 0;
	v.it_interval.tv_usec = 0;
	v.it_value = v.it_interval;
	setitimer (ITIMER_VIRTUAL, &v, 0);
	profiling = False;
	/*
	 * expr nodes clear their accumulated time 
	 * on GC when profiling is false 
	 */
	MemCollect ();
    }
    return previous ? TrueVal : FalseVal;
}
