/* $Header: /local/src/CVS/nickle/opcode.h,v 1.16 2001/04/18 15:50:05 keithp Exp $ */

/*
 * Copyright (C) 1988-2001 Keith Packard and Bart Massey.
 * All Rights Reserved.  See the file COPYING in this directory
 * for licensing information.
 */

#ifndef _CODE_H_
#define _CODE_H_

typedef enum _OpCode {
    OpNoop,
    /*
     * Statement op codes
     */
    OpIf, 
    OpElse,
    OpWhile, 
    OpEndWhile,
    OpDo,
    OpFor, 
    OpEndFor,
    OpCase,
    OpTagCase,
    OpDefault,
    OpTagDefault,
    OpBreak, 
    OpContinue,
    OpReturn,
    OpReturnVoid,
    OpFunction,
    OpFork,
    OpCatch,
    OpException,
    OpEndCatch,
    OpRaise,
    OpTwixt,
    OpTwixtDone,
    OpEnterDone,
    OpLeaveDone,
    OpUnwind,
    /*
     * Expr op codes
     */
    OpName,
    OpNameRef,
    OpNameRefStore,
    OpConst,
    OpBuildArray,
    OpInitArray,
    OpBuildStruct,
    OpInitStruct,
    OpBuildUnion,
    OpInitUnion,
    OpArray,
    OpArrayRef,
    OpArrayRefStore,
    OpCall,
    OpTailCall,
    OpDot,
    OpDotRef,
    OpDotRefStore,
    OpArrow,
    OpArrowRef,
    OpArrowRefStore,
    OpObj,
    OpStaticInit,
    OpStaticDone,
    OpStar,
    OpUminus,
    OpLnot,
    OpBang,
    OpFact,
    OpPreInc, 
    OpPostInc,
    OpPreDec, 
    OpPostDec,
    OpPlus,
    OpMinus,
    OpTimes,
    OpDivide,
    OpDiv,
    OpMod,
    OpPow,
    OpShiftL,
    OpShiftR,
    OpQuest, 
    OpColon,
    OpLxor,
    OpLand, 
    OpLor,
    OpAnd, 
    OpOr,
    OpAssign,
    OpAssignPlus, 
    OpAssignMinus,
    OpAssignTimes,
    OpAssignDivide,
    OpAssignDiv,
    OpAssignMod,
    OpAssignPow,
    OpAssignShiftL,
    OpAssignShiftR,
    OpAssignLxor,
    OpAssignLand,
    OpAssignLor,
    OpInitialize,
    OpEq,
    OpNe,
    OpLt,
    OpGt,
    OpLe,
    OpGe,
    OpEnd
} OpCode;

#endif /* _CODE_H_ */
