/* $Header: /local/src/CVS/nickle/frame.c,v 1.9 2001/04/09 03:20:02 keithp Exp $ */

/*
 * Copyright (C) 1988-2001 Keith Packard and Bart Massey.
 * All Rights Reserved.  See the file COPYING in this directory
 * for licensing information.
 */

#include	"nickle.h"

static void
FrameMark (void *object)
{
    Frame   *frame = object;

    do
    {
	MemReference (frame->staticLink);
	MemReference (frame->function);
	MemReference (frame->frame);
	MemReference (frame->statics);
	MemReference (frame->saveCode);
	frame = frame->previous;
    } while (MemReferenceNoRecurse (frame) == 0);
}

DataType FrameType = { FrameMark, 0 };

FramePtr
NewFrame (Value		function,
	  FramePtr	previous,
	  FramePtr	staticLink,
	  BoxTypesPtr	dynamics,
	  BoxPtr	statics)
{
    ENTER ();
    FramePtr	frame;

    frame = ALLOCATE (&FrameType, sizeof (Frame));
    frame->previous = previous;
    frame->staticLink = staticLink;
    frame->function = function;
    if (dynamics)
	frame->frame = NewTypedBox (False, False, dynamics);
    frame->statics = statics;
    RETURN (frame);
}
